// utils/socket.js
export const registerSocketHandlers = (io) => {
  io.on('connection', (socket) => {
    console.log('🟢 Client connected:', socket.id);

    // Example: on disconnect
    socket.on('disconnect', () => {
      console.log('🔴 Client disconnected:', socket.id);
    });

    // Example: broadcast message
    socket.on('send-message', (msg) => {
      console.log('📩 Message received:', msg);
      io.emit('receive-message', msg); // broadcast to all clients
    });
  });
};
