import axios from "axios";
import { v4 as uuidv4 } from "uuid";
import dotenv from "dotenv";

dotenv.config();

export const FLW_SECRET_KEY = process.env.FLW_SECRET_KEY;
const FLW_API = "https://api.flutterwave.com/v3";

export async function makePayout({
  account_bank,
  account_number,
  beneficiary_name,
  amount,
  currency = "UGX",
  narration = "Payout from system",
  reference = `ref_${uuidv4().slice(0, 8)}`,
}) {
  try {
    const payload = {
      account_bank,
      account_number,
      beneficiary_name,
      amount,
      currency,
      narration,
      reference,
      callback_url: `${process.env.BASE_URL}/api/payments/payout-callback`,
      debit_currency: currency,
    };

    const response = await axios.post(`${FLW_API}/transfers`, payload, {
      headers: {
        Authorization: `Bearer ${FLW_SECRET_KEY}`,
        "Content-Type": "application/json",
      },
    });

    if (response.data.status === "success") {
      return {
        success: true,
        data: response.data.data,
        message: response.data.message,
      };
    } else {
      return {
        success: false,
        message: response.data.message || "Payout failed",
        error: response.data,
      };
    }
  } catch (err) {
    console.error("Payout error:", err.message);
    return {
      success: false,
      message: "Payout error",
      error: err.response?.data || err.message,
    };
  }
}
