import mongoose from 'mongoose';
import dotenv from 'dotenv';
import Permission from '../models/Permission.js';

dotenv.config();

const permissionsToCreate = [
  { name: 'dashboard', label: 'Dashboard Access' },
  { name: 'leadership', label: 'Leadership Management' },
  { name: 'delegates', label: 'Delegate Management' },
  { name: 'communications', label: 'Communications Module' },
  { name: 'special_interest_groups', label: 'Special Interest Groups' },
  { name: 'payments', label: 'Payments Module' },
  { name: 'results', label: 'Results Viewer' },
  { name: 'settings', label: 'System Settings' },
  { name: 'user_management', label: 'User Management' }
];

const createPermissions = async () => {
  try {
    await mongoose.connect(process.env.MONGO_URI);
    console.log('✅ Connected to MongoDB');

    for (const perm of permissionsToCreate) {
      const exists = await Permission.findOne({ name: perm.name });

      if (exists) {
        console.log(`⚠️  Permission "${perm.name}" already exists`);
      } else {
        await Permission.create(perm);
        console.log(`✅ Created permission: ${perm.name}`);
      }
    }

    await mongoose.disconnect();
    console.log('🚪 Disconnected');
    process.exit(0);
  } catch (err) {
    console.error('❌ Error creating permissions:', err.message);
    process.exit(1);
  }
};

createPermissions();
