import mongoose from "mongoose";
import dotenv from "dotenv";
import bcrypt from "bcrypt";
import User from "../models/User.js";

dotenv.config();

await mongoose.connect(process.env.MONGO_URI);

const password = await bcrypt.hash("123123123", 10);

const existingAdmin = await User.findOne({ isAdmin: true });

if (existingAdmin) {
    console.log("Admin already exists");
} else {
    await User.create({
        name: "Admin",
        email: "admin@example.com",
        password,
        isAdmin: true,
    });
    console.log("✅ Admin user created");
}

await mongoose.disconnect();
process.exit();
