import express from 'express';
import {
  createUser,
  getUsers,
  updateUser,
  deleteUser,
  toggleStatus
} from '../controllers/userController.js';

import { requireAuth, requireAdmin } from '../middleware/authMiddleware.js';

const router = express.Router();

router.get('/', requireAuth, getUsers);
router.post('/', requireAuth, requireAdmin, createUser);
router.put('/:id', requireAuth, requireAdmin, updateUser);
router.patch('/:id/status', requireAuth, requireAdmin, toggleStatus);
router.delete('/:id', requireAuth, requireAdmin, deleteUser);

export default router;
