import express from "express";
import {
    getSystemSettings,
    saveSystemSettings,
    exportAllData,
    backupDatabase,
} from "../controllers/systemController.js";

const router = express.Router();

router.get("/system", getSystemSettings);
router.post("/system", saveSystemSettings);
router.get("/export-data", exportAllData);
router.post("/backup-db", backupDatabase);

export default router;
