import express from "express";
import {
  initiatePayoutToLeaders,
  handlePayoutCallback,
  getPayments,
  deleteAllPayments,
  getPaymentSummary,
  getRecipientsCount,
  initiatePayoutToSingleLeader
} from "../controllers/paymentController.js";
import { requireAuth } from "../middleware/authMiddleware.js";

const router = express.Router();
router.get("/summary", getPaymentSummary);
router.post("/payout", requireAuth, initiatePayoutToLeaders);
router.post("/payout/single",requireAuth, initiatePayoutToSingleLeader);
router.post("/payout-callback", handlePayoutCallback);
router.get("/", requireAuth, getPayments);
router.get("/recipients-count", requireAuth, getRecipientsCount);
router.delete("/delete-all", requireAuth, deleteAllPayments);

export default router;
