import express from "express";
import {
    createLeader,
    getLeaders,
    getLeaderById,
    getLeaderByNin,
    updateLeader,
    deleteLeader,
    importLeaders,
    getLeaderStats,
    getSpecialInterestLeaderCounts
} from "../controllers/LeaderController.js";
import { upload } from "../middleware/upload.js";

import { requireAuth, requireAdmin } from "../middleware/authMiddleware.js";

const router = express.Router();

// Protected routes
router.get("/", requireAuth, getLeaders);
router.get("/special-interest-count", getSpecialInterestLeaderCounts);
router.get("/stats", requireAuth, getLeaderStats);
router.get("/nin/:nin", requireAuth, getLeaderByNin);
router.get("/:id", requireAuth, getLeaderById);
router.post("/", requireAuth, createLeader);
router.put("/:id", requireAuth, updateLeader);
router.delete("/:id", requireAuth, deleteLeader);
router.post("/import", requireAuth, upload.single("file"), importLeaders);
export default router;
