import express from "express";
import multer from "multer";
import {
    registerDelegate,
    updateDelegate,
    deleteDelegate,
    deleteAllDelegates,
    getAllDelegates,
    getDelegateById,
    updateDelegateStatus,
    getDelegateStats,
    searchDelegateByUniqueId,
    verifyDelegateById,
    bulkUploadDelegates,
} from "../controllers/delegateController.js";
import { requireAuth, requireAdmin } from "../middleware/authMiddleware.js";
const router = express.Router();
const upload = multer({ dest: "uploads/" });

router.post("/bulk-upload", upload.single("file"), bulkUploadDelegates);
router.post("/register", requireAuth, registerDelegate);
router.get("/stats", requireAuth, getDelegateStats);
router.post("/search", requireAuth, searchDelegateByUniqueId);
router.patch("/:id/verify", requireAuth, verifyDelegateById);
router.put("/:id", requireAuth, updateDelegate);
router.put("/:id/status", requireAuth, updateDelegateStatus);
router.get("/", requireAuth, getAllDelegates);
router.get("/:id", requireAuth, getDelegateById);
router.delete("/:id", requireAuth, deleteDelegate);
router.delete("/", requireAuth, deleteAllDelegates);

export default router;
