import express from "express";
import {
  sendCommunication,
  getCommunications,
} from "../controllers/communicationController.js";
import { requireAuth } from "../middleware/authMiddleware.js";
import { uploadAudio } from "../middleware/upload.js";

const router = express.Router();

router.post(
  "/send",
  requireAuth,
  uploadAudio.single("audio"),
  sendCommunication
);
router.get("/", requireAuth, getCommunications); // ✅ new route
export default router;
