import mongoose from "mongoose";

const generalSchema = new mongoose.Schema(
    {
        organizationName: { type: String, required: true },
        adminTitle: { type: String },
        contactEmail: { type: String },
        contactPhone: { type: String },
        systemMessage: { type: String },
    },
    { _id: false }
);

const notificationsSchema = new mongoose.Schema(
    {
        emailAlerts: { type: Boolean, default: false },
        smsNotifications: { type: Boolean, default: false },
        systemUpdates: { type: Boolean, default: false },
        securityAlerts: { type: Boolean, default: false },
    },
    { _id: false }
);

const systemSchema = new mongoose.Schema(
    {
        otpExpiry: { type: Number, default: 5 },
        maxResendAttempts: { type: Number, default: 3 },
        sessionTimeout: { type: Number, default: 30 },
    },
    { _id: false }
);

const settingsSchema = new mongoose.Schema(
    {
        type: { type: String, required: true, unique: true },
        general: generalSchema,
        notifications: notificationsSchema,
        system: systemSchema,
    },
    { timestamps: true }
);

export default mongoose.model("Setting", settingsSchema);
