import mongoose from 'mongoose';

const recipientSchema = new mongoose.Schema(
  {
    leader: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'Leader',
      required: true,
    },
    amount: {
      type: Number,
      required: true,
      min: 0,
    },
    reference: {
      type: String,
      required: true,
      unique: true,
    },
    status: {
      type: String,
      default: 'pending',
    },
    transactionId: String,
    failureReason: String,
    processedAt: Date,
  },
  { _id: false }
);

const paymentSchema = new mongoose.Schema(
  {
    description: { type: String, trim: true },
    amount: { type: Number, required: true, min: 0 },
    recipients: [recipientSchema],
    status: { type: String, default: 'pending' },
    method: { type: String, required: true },
    category: {
      type: String,
      enum: ['mainstream', 'special-interest'],
      required: true,
    },
    specialInterestGroup: { type: String, trim: true },
    leadershipLevel: { type: String, trim: true },
    tx_ref: String, // optional
    createdBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      required: true,
    },
  },
  { timestamps: true }
);

export default mongoose.model('Payment', paymentSchema);
