import mongoose from "mongoose";

const leaderSchema = new mongoose.Schema(
  {
    firstName: { type: String, required: true },
    secondName: { type: String, required: true },
    gender: { type: String, enum: ["Male", "Female",""], default: "Male",  },
    nin: {
      type: String,
      // unique: true,
    },
     uniqueCode: { type: String },
    phone: {
      type: String,
      required: true,
      match: [/^\+256\d{9}$/, "Invalid phone format"],
    },
    category: {
      type: String,
      enum: ["mainstream", "special-interest"],
      default: "mainstream",
    },
    specialInterestGroup: {
      type: String,
      enum: [
        "youth",
        "elderly",
        "women",
        "veterans",
        "disabled",
        "workers",
        "entrepreneurs",
      ],
      required: function () {
        return this.category === "special-interest";
      },
    },
    leadershipLevel: { type: String, required: true },
    district: { type: String, required: true },
    subCounty: { type: String },
    parish: { type: String },
    village: { type: String },
    position: { type: String },
    created_by: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
  },
  { timestamps: true }
);

export default mongoose.model("Leader", leaderSchema);
