import mongoose from "mongoose";

const delegateSchema = new mongoose.Schema(
  {
    firstName: { type: String, required: true },
    secondName: { type: String, required: true },
    nin: { type: String },
    uniqueCode: { type: String },
    phone: { type: String },
    gender: { type: String, enum: ["Male", "Female", ""], default: "Male" },
    district: { type: String, required: true },
    subCounty: { type: String },
    committee: { type: String, required: true },
    position: { type: String, required: true },
    created_by: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User", // assuming you have a User model
      required: true,
    },
    status: {
      type: String,
      enum: ["pending", "verified", "rejected"],
      default: "pending",
    },
    verifiedAt: {
      type: Date,
      default: null, // ✅ initially null, set when verified
    },
  },
  { timestamps: true }
);

export default mongoose.model("Delegate", delegateSchema);
