import mongoose from 'mongoose';

const communicationSchema = new mongoose.Schema({
  messageType: {
    type: String,
    enum: ['sms', 'voice'],
    required: true
  },
  message: {
    type: String,
    required: function () {
      return this.messageType === 'sms';
    }
  },
  audioUrl: {
    type: String,
    required: function () {
      return this.messageType === 'voice';
    }
  },
  category: {
    type: String,
    enum: ['mainstream', 'special-interest'],
    default: 'mainstream',
    required: true
  },
  specialInterestGroup: { type: String }, // optional for special interest
  district: { type: String, required: true },
  recipientIds: [{ type: mongoose.Schema.Types.ObjectId, ref: 'Leader' }], // <-- NEW
  sentCount: { type: Number, default: 0 },
  status: {
    type: String,
    default: 'pending'
  },
  created_by: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  }
}, { timestamps: true });

export default mongoose.model('Communication', communicationSchema);
