import bcrypt from "bcrypt";
import User from "../models/User.js";

export const changeAdminPassword = async (req, res) => {
    try {
        const { currentPassword, newPassword } = req.body;

        const user = await User.findOne({ isAdmin: true });

        if (!user)
            return res.status(404).json({ error: "Admin user not found" });

        const isMatch = await bcrypt.compare(currentPassword, user.password);
        if (!isMatch)
            return res
                .status(400)
                .json({ error: "Current password incorrect" });

        const hashed = await bcrypt.hash(newPassword, 10);
        user.password = hashed;
        await user.save();

        res.json({ message: "Password updated successfully" });
    } catch (error) {
        console.error("Error changing password:", error);
        res.status(500).json({ error: "Failed to change password" });
    }
};

export const toggleTwoFactor = async (req, res) => {
    try {
        const { enabled } = req.body;
        const user = await User.findOne({ isAdmin: true });
        if (!user)
            return res.status(404).json({ error: "Admin user not found" });

        user.twoFactorEnabled = enabled;
        await user.save();

        res.json({ message: `2FA ${enabled ? "enabled" : "disabled"}` });
    } catch (error) {
        console.error("Error toggling 2FA:", error);
        res.status(500).json({ error: "Failed to update 2FA setting" });
    }
};
