import Setting from "../models/Setting.js";

export const getNotificationsSettings = async (req, res) => {
    try {
        let settings = await Setting.findOne({ type: "notifications" });
        if (!settings) settings = { notifications: {} };
        res.json(settings.notifications);
    } catch (error) {
        console.error("Error fetching notifications settings:", error);
        res.status(500).json({
            error: "Failed to fetch notifications settings",
        });
    }
};

export const saveNotificationsSettings = async (req, res) => {
    try {
        const data = req.body;
        let settings = await Setting.findOneAndUpdate(
            { type: "notifications" },
            { notifications: data },
            { new: true, upsert: true }
        );
        res.json(settings.notifications);
    } catch (error) {
        console.error("Error saving notifications settings:", error);
        res.status(500).json({
            error: "Failed to save notifications settings",
        });
    }
};
