import Setting from "../models/Setting.js";

export const getGeneralSettings = async (req, res) => {
    try {
        let settings = await Setting.findOne({ type: "general" });
        if (!settings) {
            settings = { general: {} };
        }
        res.json(settings.general);
    } catch (error) {
        console.error("Error fetching general settings:", error);
        res.status(500).json({ error: "Failed to fetch general settings" });
    }
};

export const saveGeneralSettings = async (req, res) => {
    try {
        const data = req.body;

        let settings = await Setting.findOneAndUpdate(
            { type: "general" },
            { general: data },
            { new: true, upsert: true }
        );

        res.json(settings.general);
    } catch (error) {
        console.error("Error saving general settings:", error);
        res.status(500).json({ error: "Failed to save general settings" });
    }
};
