import ActivityLogs from "../models/ActivityLogs.js";
import Leader from "../models/Leader.js";
import Delegate from "../models/Delegate.js";
import Communication from "../models/Communication.js";
import dayjs from "dayjs";
import Payment from "../models/Payment.js";

export const recentActivities = async (req, res) => {
    try {
        const activities = await ActivityLogs.find({});

        res.json(activities);
    } catch (error) {
        console.error(err);
        res.status(500).json({ message: "Failed to fetch dashboard data" });
    }
};

export const getDashboardData = async (req, res) => {
    try {
        const totalLeaders = await Leader.countDocuments();

        const verifiedDelegates = await Delegate.countDocuments({
            status: "verified",
        });

        const startOfMonth = dayjs().startOf("month").toDate();
        const messagesSent = await Communication.aggregate([
            { $match: { createdAt: { $gte: startOfMonth } } },
            { $group: { _id: null, total: { $sum: "$sentCount" } } },
        ]);
        const messagesCount = messagesSent.length ? messagesSent[0].total : 0;

        const levels = ["CEC", "DEC", "SCEC", "PEC", "VEC"];

        const distribution = {};
        for (const level of levels) {
            distribution[level] = await Leader.countDocuments({
                leadershipLevel: level,
            });
        }

        const payments = await Payment.aggregate([
            {
                $group: {
                    _id: null,
                    totalAmount: { $sum: "$amount" },
                },
            },
        ]);
        const totalPayments = payments.length ? payments[0].totalAmount : 0;

        const recentActivities = await ActivityLogs.find({})
            .sort({ createdAt: -1 })
            .limit(5)
            .select("title description createdAt");

        res.json({
            success: "dashboard fetched",
            data: {
                totalLeaders,
                verifiedDelegates,
                messagesSent: messagesCount,
                leadershipDistribution: distribution,
                totalPayments,
                recentActivities,
            },
        });
    } catch (err) {
        console.error(err);
        res.status(500).json({ message: "Failed to fetch dashboard data" });
    }
};
