import express from "express";
import cors from "cors";
import path from "path";
const app = express();
import userRoutes from "./routes/userRoutes.js";
import authRoutes from "./routes/authRoutes.js";
import roleRoutes from "./routes/roleRoutes.js";
import leaderRoutes from "./routes/leaderRoutes.js";
import delegateRoutes from "./routes/delegateRoutes.js";
import permissionRoutes from "./routes/permissionRoutes.js";
import communicationRoutes from "./routes/communicationRoutes.js";
import generalRoutes from "./routes/generalRoutes.js";
import notificationRoutes from "./routes/notificationRoutes.js";
import securityRoutes from "./routes/securityRoutes.js";
import systemRoutes from "./routes/systemRoutes.js";
import paymentRoutes from "./routes/paymentRoutes.js";
import dashboardRoutes from "./routes/dashboardRoutes.js";
app.use(cors({ origin: "*" }));
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use("/uploads", express.static(path.join(process.cwd(), "uploads")));
app.use("/api/users", userRoutes);
app.use("/api/auth", authRoutes);
app.use("/api/roles", roleRoutes);
app.use("/api/leaders", leaderRoutes);
app.use("/api/delegates", delegateRoutes);
app.use("/api/permissions", permissionRoutes);
app.use("/api/communications", communicationRoutes);
app.use("/api/settings", generalRoutes);
app.use("/api/settings", notificationRoutes);
app.use("/api/settings", securityRoutes);
app.use("/api/settings", systemRoutes);
app.use("/api/payments", paymentRoutes);
app.use("/api/dashboard", dashboardRoutes);
export default app;
