import http from 'http';
import { Server } from 'socket.io';
import app from './app.js';
import { registerSocketHandlers } from './utils/socket.js';
import connectDB from './db/db.js';

const server = http.createServer(app);

const io = new Server(server, {
  cors: {
    origin: '*',
    methods: ['GET', 'POST']
  }
});

// Register handlers from utils
registerSocketHandlers(io);
connectDB();
// Optional: export io for use in controllers
export { io };

const PORT = process.env.PORT || 3000;
server.listen(PORT, () => {
  console.log(`🚀 Server + Socket.IO running on port ${PORT}`);
});
