import express from 'express';
import {
  createRole,
  getRoles,
  getRoleById,
  deleteRole,
    updateRole
} from '../controllers/RoleController.js';

import { requireAuth, requireAdmin } from '../middleware/authMiddleware.js';

const router = express.Router();

// Public (or authenticated) routes
router.get('/', getRoles);
router.get('/:id', getRoleById);

// Admin-only routes
router.put('/:id', requireAuth, requireAdmin, updateRole);
router.post('/', requireAuth, requireAdmin, createRole);
router.delete('/:id', requireAuth, requireAdmin, deleteRole);

export default router;
