import fs from 'fs';
import https from 'https';
import { Server } from 'socket.io';
import dotenv from 'dotenv';
import app from './app.js';
import { registerSocketHandlers } from './utils/socket.js';
import connectDB from './db/db.js';

dotenv.config();
connectDB();

// Load SSL certificate files
const sslOptions = {
  key: fs.readFileSync(process.env.SSL_KEY_PATH),
  cert: fs.readFileSync(process.env.SSL_CERT_PATH),
  ca: fs.readFileSync(process.env.SSL_CA_PATH)
};

// Create HTTPS server
const server = https.createServer(sslOptions, app);

// Initialize Socket.IO with HTTPS server
const io = new Server(server, {
  cors: {
    origin: '*',
    methods: ['GET', 'POST']
  }
});

// Register socket handlers
registerSocketHandlers(io);

// Optional: export io for use in controllers
export { io };

const PORT = process.env.PORT || 3000;
server.listen(PORT, () => {
  console.log(`🚀 HTTPS Server + Socket.IO running on port ${PORT}`);
});
