import mongoose from "mongoose";

const userSchema = new mongoose.Schema(
  {
    name: { type: String, required: true },
    email: { type: String, required: true, unique: true },
    password: { type: String }, // for login; optional if using invite flow
    isActive: { type: Boolean, default: true },
    lastLogin: { type: Date, default: null },
    role: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Role",
    },
    isAdmin: { type: Boolean, default: false },
  },
  { timestamps: true }
);

export default mongoose.model("User", userSchema);
