import User from '../models/User.js';
import bcrypt from 'bcrypt';
import jwt from 'jsonwebtoken';

const JWT_SECRET = process.env.JWT_SECRET || 'nexus_secret'; // store in .env in production

export const login = async (req, res) => {
  try {
    const { email, password } = req.body;

    // 1. Find user by email
    const user = await User.findOne({ email }).populate('role');
    if (!user) {
      return res.status(401).json({ error: 'Invalid email or password' });
    }

    // 2. Compare password
    const valid = await bcrypt.compare(password, user.password);
    if (!valid) {
      return res.status(401).json({ error: 'Invalid email or password' });
    }

    // 3. Generate JWT token
    const token = jwt.sign(
      {
        id: user._id,
        email: user.email,
        isAdmin: user.isAdmin,
        role: user.role?.name || null
      },
      JWT_SECRET,
      { expiresIn: '7d' }
    );
const userdata = await User.findOne({ email })
  .populate({
    path: 'role',
    populate: { path: 'permissions' }  // ← this is the key fix
  });
    res.json({
      message: 'Login successful',
      token,
      user: {
        id: userdata._id,
        name: userdata.name,
        email: userdata.email,
        isAdmin: userdata.isAdmin,
        role: userdata.role?.name || null,
        permissions: userdata.role?.permissions || []
      }
    });
  } catch (err) {
    console.error('Login error:', err);
    res.status(500).json({ error: 'Internal server error' });
  }
};


export const getCurrentUser = async (req, res) => {
  try {
    const authHeader = req.headers.authorization;

    if (!authHeader || !authHeader.startsWith('Bearer ')) {
      return res.status(401).json({ error: 'No token provided' });
    }

    const token = authHeader.split(' ')[1];
    const decoded = jwt.verify(token, JWT_SECRET);

    const user = await User.findById(decoded.id).populate('role');
    if (!user) return res.status(404).json({ error: 'User not found' });

    res.json({
      id: user._id,
      name: user.name,
      email: user.email,
      isAdmin: user.isAdmin,
      role: user.role?.name || null,
      permissions: user.role?.permissions || []
    });
  } catch (err) {
    res.status(401).json({ error: 'Invalid or expired token' });
  }
};